;
; Plots the number of grid boxes with complete coverage over many different
; periods (already computed).
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then window,ysize=850
def_1color,20,color='vlblue'
def_1color,30,color='dgreen'
def_1color,40,color='lred'
def_smearcolor,fromto=[20,30]
def_smearcolor,fromto=[30,40]
;
nstep=4
;
fnout='nbox'+string(nstep,format='(I1)')+'.idlsave'
restore,filename=fnout
; Gets nstep,ndo,timey,nbox,nx,ny,minper
;
x=findgen(ndo)*nstep+timey(0)
y=x
nbox=float(nbox)
nmin=min(nbox,max=nmax,/nan)
cbox=20*(nbox-nmin)/(nmax-nmin)+20
;
scale_vert,levels=findgen(22)*(nmax-nmin)/20.+nmin,c_colors=indgen(21)+20
boxplot,cbox,x,y,$
  /xstyle,xtitle='End year',$
  /ystyle,ytitle='Start year'
scale_vert,/off
;
end
