;
; Plots maps of the change in correlation between MXD and end-of-July moisture
; deficit from the early to the late period
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='red'
def_1color,21,color='blue'
def_1color,22,color='green'
def_1color,23,color='black'
def_1color,24,color='orange'
def_1color,25,color='purple'
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device) & coast.double=1
labels=def_labels(/off)
;
; Restore all correlations
;
restore,filename='mxd_moncorr_early.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon,allp,moir,moir2
mearly=moir
restore,filename='mxd_moncorr_late.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon,allp,moir,moir2
;
pause
inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
  title='Change in r(MXD,end-of-July moisture deficit)'
;
oner=moir-mearly
;
if !d.name eq 'PS' then device,font_size=11
;
ol=where(oner lt -0.15,norange)
if norange gt 0 then plots,statlon(ol),statlat(ol),psym=8,color=24
;
rl=where((oner ge -0.15) and (oner lt -0.05),nred)
if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=20
;
bl=where((oner ge -0.05) and (oner lt 0.),nblue)
if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
;
gl=where((oner ge 0.) and (oner lt 0.05),ngreen)
if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=22
;
bl=where((oner ge 0.05) and (oner lt 0.15),nblack)
if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=23
;
pl=where(oner ge 0.15,npurple)
if npurple gt 0 then plots,statlon(pl),statlat(pl),psym=8,color=25
;
if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-160.],[35.],/data,/to_normal)
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['del-r <= -0.15          (N='+string(npurple,format='(I3)')+')',$
   'del-r =  -0.15 to -0.05 (N='+string(nblack,format='(I3)')+')',$
   'del-r =  -0.05 to +0.00 (N='+string(ngreen,format='(I3)')+')',$
   'del-r =  +0.00 to +0.05 (N='+string(nblue,format='(I3)')+')',$
   'del-r =  +0.05 to +0.15 (N='+string(nred,format='(I3)')+')',$
   'del-r >  +0.15          (N='+string(norange,format='(I3)')+')'],$
  psym=[8,8,8,8,8,8],color=[25,23,22,21,20,24],position=legpos
if !d.name eq 'PS' then device,/helvetica,/bold
;
end
