;
; Plots correlations between regional temperatures and regional MXD series
; based on varying numbers of stations.
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
titadd=strupcase(fnadd)
;
restore,filename='compbest_'+fnadd+'_fixed1950.idlsave'
;  ncomp,compname,nreg,regname,nsites,compr,compmxd,comptemp,timey
;  fixedyr,corrper,doreg,nchron,cutx,cuty,cutr,ncut
;
; Prepere for plotting
;
loadct,39
multi_plot,nrow=4,ncol=2,layout='large'
!p.multi(4)=1
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
;
; Now plot each composite region separately
;
ncomp=ncomp+1                      ; do NH as well
xname=['0.6','0.5','0.4','0.3','0.22','0.1','0.0','All']
for icomp = 0 , ncomp-1 do begin
  ;
  plot,compr(icomp,*,0),thick=2,psym=-def_sym(10),$
    title=compname(icomp),$
    xticks=7,xtickname=xname,$
    /xstyle,xtitle='Local correlation threshold',$
    /ystyle,yrange=[0.,1.],ytitle=titadd+' regional correlation'
  for j = 2 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=1
  oplot,compr(icomp,*,1),thick=2,psym=-def_sym(19)
  oplot,compr(icomp,*,2),thick=2,psym=-def_sym(18)
  ;
endfor
;
end
