;
; Plots correlations between composite regional temperatures and composite
; regional MXD series for a range of fixed grids.
;
dopub=1         ; 0=full results  1=subset for publication quality figure
if dopub eq 0 then trv=1        ; selects tree-ring-variable: 0=MXD 1=TRW
if (dopub eq 1) and (trv eq 1) then doover=1 else doover=0   ; overlay only?
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
titadd=strupcase(fnadd)
;
allfy=[1400,1500,1600,1700,1800,1950,1988]
nfixed=n_elements(allfy)
;
for i = 0 , nfixed-1 do begin
  ;
  restore,$
  filename='compbest_'+fnadd+'_fixed'+string(allfy(i),format='(I4)')+'.idlsave'
  ;
  if i eq 0 then begin
    rpos=fltarr(ncomp+1,2,nfixed,3) ; ncomp, 2=>0.22,all, nfixed, 3=raw,hi,low
  endif
  rpos(*,*,i,*)=compr(*,[4,ncut-1],*)
  ;
endfor
;
; Prepare for plotting
;
if dopub eq 0 then begin
  loadct,39
  multi_plot,nrow=5,ncol=2,layout='large'
  if !d.name eq 'X' then begin
    window,ysize=850
    !p.font=-1
  endif else begin
    !p.font=0
    device,/helvetica,/bold,font_size=9
  endelse
  multi_plot,nrow=5,ncol=2,layout='large'
  def_1color,30,color='mgrey'
endif
;
xval=[1400,1500,1600,1700,1800,1900,1983,1994]
iuse=[0,1,2,3,4,5,5,6]
for icomp = 0 , ncomp-dopub do begin
  ;
  plot,[0,1],/nodata,$
    xstyle=1,xrange=[1400,1994],xtitle='Year of fixed grid',$
    ystyle=1,yrange=[0.,1.],ytitle='Regional correlation',$
    title=compname(icomp)
  ;
  for j = 2 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=1
  ;
  if doover eq 0 then begin
    lsym=[10,19,18]
    for k = 1 , 2 do begin
      yval=reform(rpos(icomp,0,*,k))
      yval=yval(iuse)
      oplot,xval,yval,thick=6-4*dopub,psym=-def_sym(lsym(k)),color=30+dopub
    endfor
  endif
  ;
  lthi=[5+2*doover,1]
  lsty=[0,0]
  for k = 0 , 1-dopub do begin
    yval=reform(rpos(icomp,k,*,0))
    yval=yval(iuse)
    oplot,xval,yval,thick=lthi(k),linestyle=lsty(k),color=31-doover
  endfor
  ;
endfor
;
if dopub eq 0 then begin
plot,[0,1],xstyle=4,ystyle=4,/nodata
legend,['r(regional '+titadd+',regional temperature)',$
  'all chronologies','local r > 0.22',$
  'For local r > 0.22 only:','High-pass','Low-pass'],$
  linestyle=[-1,0,0,-1,0,0],thick=[0,1,5,0,2,2],psym=-[0,0,0,0,19,18],$
  color=[replicate(!p.color,4),30,30]
endif
;
end
