;
; Plots a map showing location of all MXD chronologoes
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
loadct,39
def_1color,20,color='vlgrey'
multi_plot,nrow=1
if !d.name eq 'X' then begin
  wintim,xsize=700,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
;
map=def_map(/npolar)  &  map.limit(0)=40.
mn=map.limit(0)
coast=def_coast(/off)
labels=def_labels(/off)
;
inter_boxfd,/nodata,map=map,coast=coast,labels=labels
;  title='Location of tree-ring density chronologies'
map_continents,/coasts,/fill_continents,color=20
map_continents,/coasts
map_continents,/countries,mlinestyle=1,mlinethick=0.5
map_plots,findgen(361)-180.,replicate(mn,361)
;
kl=where(statlat ge mn)
statlon=statlon(kl)
statlat=statlat(kl)
cpl_usersym,/circle,/fill
plots,statlon,statlat,psym=8,symsize=0.7
cpl_usersym,/circle
plots,statlon,statlat,psym=8,symsize=0.7,color=!p.background
;
; Overlay regions
;
map_plots,[-15.,-15.],[90.,53],thick=3
map_plots,[61.,61.],[90.,60.],thick=3
map_plots,[128.,128.],[90.,60.],thick=3
map_plots,[-170.,-170.],[90.,50.],thick=3
map_plots,[-125.,-125.],[90.,60.],thick=3
map_plots,[-45.,-45.],[90.,40.],thick=3
map_plots,[30.,30.],[60.,53],thick=3
;map_plots,[115.,115.],[60.,mn],thick=3
;map_plots,[60.,60.],[40.,mn],thick=3
;map_plots,[-135.,-135.],[50.,mn],thick=3
map_plots,[-100.,-100.],[50.,mn],thick=3
map_plots,[-105.,-105.],[55.,50.],thick=3
map_plots,[-120.,-120.],[60.,55.],thick=3
;
;y1=[60.,50.,30.,60.,55.,40.,53.,35.,60.,40.,25.]
;x1=[-180.,-170.,-135.,-125.,-120.,-100.,-15.,-15.,30.,30.,60.]
;x2=[-170.,-100.,-100.,-120.,-105.,-45.,30.,30.,180.,115.,115.]
y1=[60.,50.,60.,55.,40.,53.,60.]
x1=[-180.,-170.,-125.,-120.,-100.,-15.,30.]
x2=[-170.,-100.,-120.,-105.,-45.,30.,180.]
for i = 0 , n_elements(y1)-1 do begin
  n=x2(i)-x1(i)+1
  xval=findgen(n)+x1(i)
  yval=replicate(y1(i),n)
  map_plots,xval,yval,thick=3
endfor
;
regname=['NEUR','','NSIB','ESIB','','',$
  '','NWNA','ECCA']
reglat=[  73,  35,  85,  81,  53,  37,  30,  67,  62]
reglon=[ -10, -29,  86,-176,  38,  70,-135,-129, -72]
for i = 0 , n_elements(regname)-1 do $
  xyouts,reglon(i),reglat(i),regname(i),charsize=0.7
;
end
