;
; Plots a map showing location of all MXD chronologoes
;
dogen=0         ; 0=all symbols the same, 1=different colour per genus
genname=['AB','LA','PC','PI','PS','TS']
ngen=n_elements(genname)
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
loadct,39
def_1color,20,color='green'
def_1color,21,color='lsand'
def_1color,22,color='red'
def_1color,30,color='red'
def_1color,31,color='green'
def_1color,32,color='lblue'
def_1color,33,color='orange'
def_1color,34,color='purple'
def_1color,35,color='yellow'
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,xsize=700,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=15
endelse
;
map=def_map(/npolar)  &  map.limit(0)=25.
map.xmargin=[4,4]
coast=def_coast(/off)
labels=def_labels(/off)
;
inter_boxfd,/nodata,map=map,coast=coast,labels=labels
;  title='Location of tree-ring density/width chronologies'+$
;    '!C( 387 chronologies, with lengths from 100 yr to 600+ yr )'
map_continents,/coasts,/fill_continents,color=21
map_continents,/coasts,color=!p.color,mlinethick=0.5
;map_continents,/countries,color=!p.color,mlinestyle=1,mlinethick=0.5
;
cpl_usersym,/circle,/fill
if dogen eq 0 then begin
  plots,statlon,statlat,psym=8,color=20,symsize=0.7
endif else begin
  tgen=strmid(tree,0,2)
  for igen = 0 , ngen-1 do begin
    kl=where(tgen eq genname(igen),ngot)
    plots,statlon(kl),statlat(kl),psym=8,color=30+igen,symsize=0.7
  endfor
endelse
cpl_usersym,/circle
plots,statlon,statlat,psym=8,thick=2,symsize=0.7
;
;statlon=[20.,27.,70.,65.,102.,-117.]
;statlat=[68.,68.,67.,66.,72.,52.3]
;cpl_usersym,/circle,/fill
;plots,statlon,statlat,psym=8,color=22,symsize=1.
;cpl_usersym,/circle
;plots,statlon,statlat,psym=8,thick=2,symsize=1.
;
; Overlay regions
;
;map_plots,[-15.,-15.],[90.,35.],thick=3
;map_plots,[61.,61.],[90.,60.],thick=3
;map_plots,[128.,128.],[90.,60.],thick=3
;map_plots,[-170.,-170.],[90.,50.],thick=3
;map_plots,[-125.,-125.],[90.,60.],thick=3
;map_plots,[-45.,-45.],[90.,40.],thick=3
;map_plots,[30.,30.],[60.,35.],thick=3
;map_plots,[115.,115.],[60.,23.],thick=3
;map_plots,[60.,60.],[40.,23.],thick=3
;map_plots,[-135.,-135.],[50.,30.],thick=3
;map_plots,[-100.,-100.],[50.,30.],thick=3
;map_plots,[-105.,-105.],[55.,50.],thick=3
;map_plots,[-120.,-120.],[60.,55.],thick=3
;
;y1=[60.,50.,30.,60.,55.,40.,53.,35.,60.,40.,23.]
;x1=[-180.,-170.,-135.,-125.,-120.,-100.,-15.,-15.,30.,30.,60.]
;x2=[-170.,-100.,-100.,-120.,-105.,-45.,30.,30.,180.,115.,115.]
;for i = 0 , n_elements(y1)-1 do begin
;  n=x2(i)-x1(i)+1
;  xval=findgen(n)+x1(i)
;  yval=replicate(y1(i),n)
;  map_plots,xval,yval,thick=3
;endfor
;
; Overlay regions
;
t=4
map_plots,[-15.,-15.],[90.,35.],thick=t
map_plots,[61.,61.],[90.,60.],thick=t
map_plots,[128.,128.],[90.,60.],thick=t
map_plots,[-170.,-170.],[90.,50.],thick=t
map_plots,[-125.,-125.],[90.,60.],thick=t
map_plots,[-45.,-45.],[90.,40.],thick=t
map_plots,[30.,30.],[60.,35.],thick=t
map_plots,[115.,115.],[60.,25.],thick=t
map_plots,[60.,60.],[40.,25.],thick=t
map_plots,[-135.,-135.],[50.,30.],thick=t
map_plots,[-100.,-100.],[50.,30.],thick=t
map_plots,[-105.,-105.],[55.,50.],thick=t
map_plots,[-120.,-120.],[60.,55.],thick=t
;
y1=[60.,50.,30.,60.,55.,40.,53.,35.,60.,40.,25.]
x1=[-180.,-170.,-135.,-125.,-120.,-100.,-15.,-15.,30.,30.,60.]
x2=[-170.,-100.,-100.,-120.,-105.,-45.,30.,30.,180.,115.,115.]
for i = 0 , n_elements(y1)-1 do begin
  n=x2(i)-x1(i)+1
  xval=findgen(n)+x1(i)
  yval=replicate(y1(i),n)
  map_plots,xval,yval,thick=t
endfor
;
regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP',$
  'WNA','NWNA','ECCA']
reglat=[  73,  35,  85,  81,  53,  37,  30,  67,  62]
reglon=[ -10, -25,  86,-176,  38,  70,-135,-129, -72]
for i = 0 , n_elements(regname)-1 do $
  xyouts,reglon(i),reglat(i),regname(i),charsize=0.7
;
if dogen eq 1 then begin
  cpl_usersym,/circle,/fill
  legend,genname,psym=replicate(8,ngen),colors=indgen(ngen)+30
endif
;
end
