;
; Plots maps of correlations between MXD and end-of-July moisture deficit
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='red'          ; for 0.<=r
def_1color,21,color='deepblue'     ; for -0.05<=r<0.
def_1color,22,color='green'        ; for -0.25<=r<-0.05
def_1color,23,color='black'        ; for r<-0.25
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device) & coast.double=1
labels=def_labels(/off)
;
; Repeat for full, early and late periods
;
for iper = 0 , 2 do begin
  ;
  ; Restore all correlations
  ;
  case iper of
    0: restore,filename='mxd_moncorr.idlsave'
    1: restore,filename='mxd_moncorr_early.idlsave'
    2: restore,filename='mxd_moncorr_late.idlsave'
  endcase
  ;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon,allp,moir,moir2
  ;
  case iper of
    0: mtit='  (FULL PERIOD)'
    1: mtit='  (EARLY PERIOD)'
    2: mtit='  (LATE PERIOD)'
  endcase
  ;
pause
inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
  title='r(MXD,end-of-July moisture deficit)'+mtit
;
oner=-moir
;
if !d.name eq 'PS' then device,font_size=11
;
rl=where(oner lt 0.,nred)
if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=20
;
bl=where((oner ge 0.) and (oner lt 0.05),nblue)
if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
;
gl=where((oner ge 0.05) and (oner lt 0.25),ngreen)
if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=22
;
bl=where(oner ge 0.25,nblack)
if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=23
;
if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-160.],[35.],/data,/to_normal)
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['r <= -0.25          (N='+string(nblack,format='(I3)')+')',$
   'r =  -0.25 to -0.05 (N='+string(ngreen,format='(I3)')+')',$
   'r =  -0.05 to +0.00 (N='+string(nblue,format='(I3)')+')',$
   'r >  +0.00          (N='+string(nred,format='(I3)')+')'],$
  psym=[8,8,8,8],color=[23,22,21,20],position=legpos
if !d.name eq 'PS' then device,/helvetica,/bold
;
endfor
;
restore,filename='mxd_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon,allp,moir,moir2
;
pause
inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
  title='r(April-September temperature,end-of-July moisture deficit)'
;
oner=moir2
;
if !d.name eq 'PS' then device,font_size=11
;
rl=where(oner lt 0.,nred)
if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=20
;
bl=where((oner ge 0.) and (oner lt 0.2),nblue)
if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
;
gl=where((oner ge 0.2) and (oner lt 0.5),ngreen)
if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=22
;
bl=where(oner ge 0.5,nblack)
if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=23
;
if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-160.],[35.],/data,/to_normal)
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['r >= +0.50          (N='+string(nblack,format='(I3)')+')',$
   'r =  +0.20 to +0.50 (N='+string(ngreen,format='(I3)')+')',$
   'r =  +0.00 to +0.20 (N='+string(nblue,format='(I3)')+')',$
   'r <  +0.00          (N='+string(nred,format='(I3)')+')'],$
  psym=[8,8,8,8],color=[23,22,21,20],position=legpos
if !d.name eq 'PS' then device,/helvetica,/bold
;
end
