;
; Plots maps of correlations between MXD and Apr-Sep temperature and
; May-Aug precipitation.
;
trv=1           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnadd='mxd'
    iseas=18
    seastit='Apr-Sep temperature'
    end
  1: begin
    fnadd='trw'
    iseas=20
    seastit='Jun-Aug temperature'
    end
endcase
titadd=strupcase(fnadd)
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='red'          ; for rMT<-0.05      & 0.05<rMP
def_1color,21,color='deepblue'     ; for -0.05<=rMT<0.1 & -0.1<rMP<=0.05
def_1color,22,color='green'        ; for 0.1<=rMT<0.25  & -0.25<rMP<=-0.1
def_1color,23,color='black'        ; for 0.25<=rMT      & rMP<=-0.25
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device) & coast.double=1
labels=def_labels(/off)
;
; Repeat for full, early and late periods
;
for iper = 0 , 0 do begin
  ;
  ; Restore all correlations
  ;
  case iper of
    0: restore,filename=fnadd+'_moncorr.idlsave'
    1: restore,filename=fnadd+'_moncorr_early.idlsave'
    2: restore,filename=fnadd+'_moncorr_late.idlsave'
  endcase
  ;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
  ;
  case iper of
    0: mtit='  (FULL PERIOD)'
    1: mtit='  (EARLY PERIOD)'
    2: mtit='  (LATE PERIOD)'
  endcase
  ;
  ; Plot temperature correlations
  ;
  pause
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
    title='r( '+titadd+' , '+seastit+' )'+mtit
;
oner=reform(allr(*,iseas,1))
;
if !d.name eq 'PS' then device,font_size=11
bl=where(oner ge 0.25,nblack)
if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=23
;
gl=where((oner ge 0.1) and (oner lt 0.25),ngreen)
if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=22
;
bl=where((oner ge -0.05) and (oner lt 0.1),nblue)
if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
;
rl=where(oner lt -0.05,nred)
if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=20
if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-160.],[35.],/data,/to_normal)
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['r >= +0.25          (N='+string(nblack,format='(I3)')+')',$
   'r =  +0.10 to +0.25 (N='+string(ngreen,format='(I3)')+')',$
   'r =  -0.05 to +0.10 (N='+string(nblue,format='(I3)')+')',$
   'r <  -0.05          (N='+string(nred,format='(I3)')+')'],$
  psym=[8,8,8,8],color=[23,22,21,20],position=legpos
if !d.name eq 'PS' then device,/helvetica,/bold
;
pause
inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
  title='r('+titadd+',May-August precipitation)'+mtit
;
oner=-reform(allr(*,19,0))
;
if !d.name eq 'PS' then device,font_size=11
bl=where(oner ge 0.25,nblack)
if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=23
;
gl=where((oner ge 0.1) and (oner lt 0.25),ngreen)
if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=22
;
bl=where((oner ge -0.05) and (oner lt 0.1),nblue)
if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
;
rl=where(oner lt -0.05,nred)
if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=20
if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-160.],[35.],/data,/to_normal)
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['r <= -0.25          (N='+string(nblack,format='(I3)')+')',$
   'r =  -0.25 to -0.10 (N='+string(ngreen,format='(I3)')+')',$
   'r =  -0.10 to +0.05 (N='+string(nblue,format='(I3)')+')',$
   'r >  +0.05          (N='+string(nred,format='(I3)')+')'],$
  psym=[8,8,8,8],color=[23,22,21,20],position=legpos
if !d.name eq 'PS' then device,/helvetica,/bold
;
endfor
;
end
