;
; Plots correlations between regional temperatures and regional MXD series
; based on varying numbers of stations.
;
restore,filename='regbest_fixed1950.idlsave'
;  nreg,regname,nsites,regr,locr,bestx,besty,bestmxd,regtemp,timey
;  fixedyr,corrper,doreg,maxntree
;
; Prepere for plotting
;
loadct,39
multi_plot,nrow=6,ncol=2,layout='large'
!p.multi(4)=1
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
;
; Now plot each region separately
;
for ireg = 0 , nreg-1 do begin
  ;
  pause
  plot,locr(*,ireg),thick=3,$
    title=regname(ireg),$
    /xstyle,xtickformat='nolabels',$
    /ystyle,yrange=[-0.45,0.95],ymargin=[0,2],ytitle='Local correlation'
  for j = -4 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=(j ne 0)
  plot,regr(*,ireg,0),thick=3,$
    /xstyle,xtitle='Chronology',$
    /ystyle,yrange=[-0.45,0.95],ymargin=[4,0],ytitle='Regional correlation'
  for j = -4 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=(j ne 0)
  oplot,regr(*,ireg,1),thick=6,linestyle=2
  oplot,regr(*,ireg,2),thick=6
  ;
endfor
;
end
