;
; Plots correlations between regional temperatures and regional MXD series
; based on varying numbers of stations, for a range of fixed grids.
;
; FOR PUBLICATION GRAPH, DO:
; (1) set dopub=1 in both 'pl_regbest_fixed.pro' and 'pl_hemibest_fixed.pro'
; (2) set trv=0 in 'pl_regbest_fixed.pro'
; (3) .run pl_regbest_fixed
; (4) .run pl_hemibest_fixed
; (5) set trv=1 in 'pl_regbest_fixed.pro'
; (6) .run pl_regbest_fixed
; (7) .run pl_hemibest_fixed
;
dopub=1         ; 0=full results  1=subset for publication quality figure
trv=1           ; selects tree-ring-variable: 0=MXD 1=TRW
if (dopub eq 1) and (trv eq 1) then doover=1 else doover=0   ; overlay only?
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
titadd=strupcase(fnadd)
;
allfy=[1400,1500,1600,1700,1800,1950,1988]
nfixed=n_elements(allfy)
;
for i = 0 , nfixed-1 do begin
  ;
  restore,filename='regbest_'+fnadd+'_fixed'+string(allfy(i),format='(I4)')+'.idlsave'
  ;  nreg,regname,nsites,regr,locr,bestx,besty,bestmxd,regtemp,timey
  ;  fixedyr,corrper,doreg,maxntree
  ;
  if i eq 0 then begin
    alllr=fltarr(maxntree,nreg,nfixed)
    allrr=fltarr(maxntree,nreg,nfixed)
    allpos=fltarr(nreg,3,nfixed)
    rpos=fltarr(nreg,3,nfixed,3)      ; nreg, 3=all,>0.22,best, nfixed, 3=raw,hi,low
  endif
  ;
  alllr(*,*,i)=locr(*,*)
  allrr(*,*,i)=regr(*,*,0)
  allpos(*,0,i)=(nsites(*)-1) > 0
  allpos(*,1,i)=cutsites(*)-1
  for j = 0 , nreg-1 do begin
    dummy=max(regr(*,j,0),/nan,dum2)
    allpos(j,2,i)=dum2
    rpos(j,0,i,*)=regr(allpos(j,0,i),j,*)
    if allpos(j,1,i) ge 0 then begin
      rpos(j,1,i,*)=regr(allpos(j,1,i),j,*)
    endif else begin
      rpos(j,1,i,*)=!values.f_nan
    endelse
    rpos(j,2,i,*)=regr(dum2,j,*)
  endfor
  ;
endfor
;
; Prepare for plotting
;
loadct,39
if dopub eq 0 then multi_plot,nrow=6,ncol=2,layout='large'
if doover eq 0 then begin
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
endif
def_1color,20,color='red'
def_1color,21,color='green'
def_1color,22,color='blue'
def_1color,23,color='black'
def_1color,30,color='mgrey'
def_1color,31,color='black'
;
; Now plot each region separately
;
if dopub eq 0 then begin
  !p.multi(4)=1
for ireg = 0 , nreg-1 do begin
  ;
  pause
  ;
  plot,alllr(*,ireg,0),/nodata,$
    title=regname(ireg),$
    /xstyle,xtickformat='nolabels',$
    /ystyle,yrange=[-0.45,0.95],ymargin=[0,2],ytitle='Local correlation'
  for j = -4 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=(j ne 0)
  for j = 2 , nfixed-1 do begin
    oplot,alllr(*,ireg,j),thick=3,color=18+j
    for k = 0 , 2 do oplot,replicate(allpos(ireg,k,j),2),!y.crange,color=18+j
  endfor
  ;
  plot,allrr(*,ireg,0),/nodata,$
    /xstyle,xtitle='Chronology',$
    /ystyle,yrange=[-0.45,0.95],ymargin=[4,0],ytitle='Regional correlation'
  for j = -4 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=(j ne 0)
  for j = 2 , nfixed-1 do begin
    oplot,allrr(*,ireg,j),thick=3,color=18+j
    for k = 0 , 2 do oplot,replicate(allpos(ireg,k,j),2),!y.crange,color=18+j
  endfor
  ;
endfor
  ;
  plot,[0,1],/nodata,xstyle=4,ystyle=4
  legend,['1600','1700','1800','1900 (all sites)'],$
    color=[20,21,22,23],thick=[3,3,3,3]
endif
;
if doover eq 1 then begin
  !p.multi(0)=12
endif else begin
  multi_plot,nrow=5+dopub,ncol=2,layout='large'
  pause
endelse
;
xval=[1400,1500,1600,1700,1800,1900,1983,1994]
iuse=[0,1,2,3,4,5,5,6]
for ireg = 0 , nreg-1 do begin
  ;
  plot,[0,1],/nodata,$
    xstyle=1,xrange=[1400,1994],xtitle='Year of fixed grid',$
    ystyle=1,yrange=[0.,1.],ytitle='Regional correlation',$
    title=regname(ireg)
  ;
  for j = 2 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=1
  ;
  if doover eq 0 then begin
    lsym=[10,19,18]
    for k = 1 , 2 do begin
      yval=reform(rpos(ireg,1,*,k))
      yval=yval(iuse)
      oplot,xval,yval,thick=6-4*dopub,psym=-def_sym(lsym(k)),color=30+dopub
    endfor
  endif
  ;
  lthi=[1,5+2*doover,3]
  lsty=[0,0,2]
  for k = dopub , 1 do begin
    yval=reform(rpos(ireg,k,*,0))
    yval=yval(iuse)
    oplot,xval,yval,thick=lthi(k),linestyle=lsty(k),color=31-doover
  endfor
  ;
endfor
;
if dopub eq 0 then begin
  plot,[0,1],xstyle=4,ystyle=4,/nodata
  legend,['r(regional '+titadd+',regional temperature)',$
    'all chronologies','local r > 0.22',$      ;'best chronologies',$
    'For local r > 0.22 only:','High-pass','Low-pass'],$
    linestyle=[-1,0,0,-1,0,0],thick=[0,1,5,0,2,2],psym=-[0,0,0,0,19,18],$
    color=[replicate(!p.color,4),30,30]
endif
;
end
