;
; Plots correlations between regional temperatures and regional MXD series
; based on varying numbers of stations.  Compares results based on full regions
; with those based on co-located data only.
;
restore,filename='fullregbest_fixed1950.idlsave'
;  nreg,regname,nsites,regr,locr,bestx,besty,bestmxd,regtemp,timey
;  fixedyr,corrper,doreg,maxntree
keepregr=regr
;
restore,filename='regbest_fixed1950.idlsave'
;  nreg,regname,nsites,regr,locr,bestx,besty,bestmxd,regtemp,timey
;  fixedyr,corrper,doreg,maxntree
;
; Prepere for plotting
;
loadct,39
multi_plot,nrow=5,ncol=2,layout='large'
!p.multi(4)=1
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
def_1color,20,color='red'
;
; Now plot each region separately
;
for ireg = 0 , nreg-1 do begin
  ;
  plot,regr(*,ireg,0),thick=3,$
    /xstyle,xtitle='Chronology',title=regname(ireg),$
    /ystyle,yrange=[-0.45,0.95],ytitle='Regional correlation'
  for j = -4 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=(j ne 0)
  oplot,regr(*,ireg,1),thick=6,linestyle=2
  oplot,regr(*,ireg,2),thick=6
  oplot,keepregr(*,ireg,0),thick=3,color=20
  oplot,keepregr(*,ireg,1),thick=6,linestyle=2,color=20
  oplot,keepregr(*,ireg,2),thick=6,color=20
  ;
endfor
;
bc=!p.color
plot,[0,1],/nodata,xstyle=4,ystyle=4
legend,['r(regional MXD,regional temperature)','for co-located boxes',$
  'for full regions','Filter used:','unfiltered','high-pass','low-pass'],$
  linestyle=[-1,0,0,-1,0,2,0],thick=[0,3,3,0,3,6,6],color=[bc,bc,20,bc,bc,bc,bc]
;
end
