;
; Plots genus averages of correlations between MXD and
; monthly & seasonal precip. and temperature.
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
  2: fnadd='mxd-trw'
endcase
titadd=strupcase(fnadd)
;
; Restore all correlations
;
restore,filename=fnadd+'_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
;
; Restore all chronologies, to obtain genus information
; (always use MXD since they should be the same)
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
genname=['AB','LA','PC','PI','PS','TS']
nreg=n_elements(genname)
tgen=strmid(tree,0,2)        ; gets first two letters of Tree Genus/Species
;
; For each genus, average the site-by-site correlations together (and also
; find the range, by using the mean +- 2sd, unless < 10 sites in which case
; max and min are used)
;
regr=fltarr(nreg,ncorr,nvar)
regmin=fltarr(nreg,ncorr,nvar)
regmax=fltarr(nreg,ncorr,nvar)
ntree=fltarr(nreg)
for i = 0 , nreg-1 do begin
  treelist=where(tgen eq genname(i),n)
  ntree(i)=n
  oner=allr(treelist,*,*)
  totr=total(oner,1)/float(n)
  regr(i,*,*)=totr(*,*)
  for j = 0 , ncorr-1 do begin
    for k = 0 , nvar-1 do begin
      rrr=reform(oner(*,j,k))
      kl=where(finite(rrr),nrrr)
      rrr=rrr(kl)
      if nrrr lt 10 then begin
        regmin(i,j,k)=min(rrr)
        regmax(i,j,k)=max(rrr)
      endif else begin
        dummy=moment(rrr,sdev=sdev)
        regmin(i,j,k)=(regr(i,j,k)-2.*sdev) > (-1.)
        regmax(i,j,k)=(regr(i,j,k)+2.*sdev) < (1.)
      endelse
    endfor
  endfor
endfor
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='caption'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='vlgrey'
def_1color,21,color='mgrey'
;
for i = 0 , nreg-1 do begin
  for ivar = 0 , nvar-1 do begin
    pause
    x=findgen(28)
    yy=reform(regr(i,*,ivar))
    yymin=reform(regmin(i,*,ivar))
    yymax=reform(regmax(i,*,ivar))
    y=fltarr(28)*!values.f_nan
    ymin=fltarr(28)*!values.f_nan
    ymax=fltarr(28)*!values.f_nan
    yloc=[indgen(16)+1,indgen(5)*2+18]
    y(yloc)=yy(*)
    ymin(yloc)=yymin(*)
    ymax(yloc)=yymax(*)
    plot,x,y,/nodata,$
      /ystyle,yrange=[-1.,1.],ytitle='Correlation',$
      xstyle=5,title='N='+string(ntree(i),format='(I3)')+'  '+$
        genname(i)+'  r('+titadd+','+varname(ivar)+')'
    for j = -10,10,2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
    oplot,!x.crange,[0.,0.]
    oplot,[7.5,7.5],!y.crange,thick=4
    cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
    if !d.name eq 'PS' then device,font_size=8
    for j = 0 , ncorr-1 do begin
      x1=replicate(x(yloc(j)),2)
      y1min=ymin(yloc(j))
      y1max=ymax(yloc(j))
      plots,x1,y1min,psym=def_sym(12)
      plots,x1,y1max,psym=def_sym(11)
      x1=x(yloc(j))+0.28
      y1=!y.crange(0)-0.05
      if !p.multi(0) le 1 then xyouts,x1,y1,corrname(j),align=1,orient=90.
    endfor
    xyouts,7.,-0.85,align=1.,'Previous!Cyear'
    xyouts,8.,-0.85,align=0.,'Same!Cyear'
    if !d.name eq 'PS' then device,font_size=14
  endfor
endfor
;
end
