;
; Plots regional and large-scale averages of PARTIAL correlations between MXD &
; monthly & seasonal precip. and temperature.
;
docol=1         ; 0=B&W 1=color
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
  2: fnadd='mxd-trw'
  3: fnadd='trwmxd'
endcase
titadd=strupcase(fnadd)
;
; Restore all correlations
;
restore,filename='datastore/'+fnadd+'_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
;
; Combine temp r with prec partial r
;
allp(*,*,1)=allp(*,*,0)
allp(*,*,0)=allr(*,*,1)
varname=reverse(varname)
conname=['',' constant Temp']
yname=['Correlation','Partial correlation']
;
if trv eq 3 then begin
  yname(0)=yname(1)
  titadd='TRW'
  conname=[' constant MXD',' constand MXD & Temp']
endif
;
; Pick off one site as an example
;
iuse=225
oner=reform(allp(iuse,*,*))
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='caption'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
if docol eq 0 then begin
  def_1color,20,color='vlgrey'
  def_1color,21,color='mgrey'
endif else begin
  def_1color,20,color='lblue'
  def_1color,21,color='mred'
endelse
;
  for ivar = 0 , nvar-1 do begin
    x=findgen(28)
    yy=reform(oner(*,ivar))
    y=fltarr(28)*!values.f_nan
    yloc=[indgen(16)+1,indgen(5)*2+18]
    y(yloc)=yy(*)
    plot,x,y,/nodata,$
      /ystyle,yrange=[-1.,1.],ytitle=yname(ivar),$
      xstyle=5,$
      title='r('+titadd+','+varname(ivar)+')'+conname(ivar)+' at  '+$
        string(statlat(iuse),format='(F4.1)')+' N  '+$
        string(statlon(iuse),format='(F5.1)')+' E'
    for j = -10,10,2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
    oplot,!x.crange,[0.,0.]
    oplot,[7.5,7.5],!y.crange,thick=4
    cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
    if !d.name eq 'PS' then device,font_size=8
    for j = 0 , ncorr-1 do begin
      x1=x(yloc(j))+0.28
      y1=!y.crange(0)-0.05
      xyouts,x1,y1,corrname(j),align=1,orient=90.
    endfor
    xyouts,7.,-0.85,align=1.,'Previous!Cyear'
    xyouts,8.,-0.85,align=0.,'Same!Cyear'
    if !d.name eq 'PS' then device,font_size=14
  endfor
;
end
