;
; Plots regional and large-scale averages of correlations between
; monthly & seasonal precip. and temperature.
;
dotem=1         ; 0=use CRUTEM1, 1=use CRUTEM2v
if dotem eq 0 then begin
  savtem=''
endif else begin
  savtem='ct2v_'
endelse
;
; Restore all correlations
;
restore,filename='datastore/'+savtem+'tp_moncorr.idlsave'
;  allr,ncorr,nchron,corrname,statlat,statlon
;
; Restore regional breakdown
;
restore,filename='reg_mxdlists.idlsave'
;  ntree,treelist,nreg,regname
;
; For each region, average the site-by-site correlations together
;
regr=fltarr(nreg,ncorr)
for i = 0 , nreg-1 do begin
  n=ntree(i)
  oner=allr(treelist(0:n-1,i),*)
  totr=total(oner,1)/float(n)
  regr(i,*)=totr(*)
endfor
;
; Now generate three extra composite regions
;
newr=fltarr(nreg+3,ncorr)
newr(0:nreg-1,*)=regr(*,*)
regname=[regname,'HILAT','LOLAT','NH']
;
rlist=[0,2,3,7,8]
oner=total(regr(rlist,*),1)/float(n_elements(rlist))
newr(nreg,*)=oner(*)
;
rlist=[1,4,5,6]
oner=total(regr(rlist,*),1)/float(n_elements(rlist))
newr(nreg+1,*)=oner(*)
;
oner=total(regr,1)/float(nreg)
newr(nreg+2,*)=oner(*)
;
regr=newr
nreg=nreg+3
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='caption'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='deepblue'
def_1color,21,color='red'
;
for i = 0 , nreg-1 do begin
  pause
  x=findgen(24)
  yy=reform(regr(i,*))
  y=fltarr(24)*!values.f_nan
  yloc=[indgen(12)+1,indgen(5)*2+14]
  y(yloc)=yy(*)
  plot,x,y,/nodata,$
    /ystyle,yrange=[-0.6,0.6],ytitle='Correlation',$
    xstyle=5,title=regname(i)+'  r(temp,prec)'
  for j = -6 , 6 , 2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
  oplot,!x.crange,[0.,0.]
  cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
  if !d.name eq 'PS' then device,font_size=8
  for j = 0 , ncorr-1 do begin
    x1=x(yloc(j))+0.25
    y1=y(yloc(j))
    if y1 lt 0 then y1=+0.05 else y1=y1+0.05
    xyouts,x1,y1,corrname(j),align=0.,orient=90.
  endfor
  if !d.name eq 'PS' then device,font_size=14
endfor
;
end
