;
; Plots long reconstructions (Age-banded, Jones, Mann(v2) and
; Yamal+Torne+Taimyr), and correlates them too!
;
; Have to restore the NEW age-banded results now to avoid overwriting key
; variables later
;
; For regional calibrated stuff
;restore,filename='bandtemp_calibrated.idlsave'
; Gets: calregts,nreg,nyr,regname,tempnyr,temptimey,tempregts,timey
;if regname(nreg-1) ne 'NH' then message,'Re-calibrate the age-banded!'
;newagetime=timey
;newagets=calregts(*,nreg-1)
;
; For allsites calibrated stuff
;restore,filename='bandalltemp_calibrated.idlsave'
; Gets: nyr,nhtit,timey,nhtemp
;if nhtit ne 'NH' then message,'Re-calibrate the age-banded!'
;newagetime=timey
;newagets=nhtemp
;
; For PCR calibrated stuff. The sm50 gets the smoothed series and appropriate
; erros - no need to smooth them!!!!
restore,filename='bandtempNHsm50_calmultipcr.idlsave'
;restore,filename='bandtempNHsm50_calmultipcr_NSIBhug.idlsave'
; Gets: nyr,nhtit,yrmxd,prednh,fullnh,predse
if nhtit ne 'NH' then message,'Re-calibrate the age-banded!'
newagetime=yrmxd
newagets=prednh
newagese=predse
;
docorr=0        ; 1=compute correlations  0=don't
thalf=50.       ; filter for high or low-pass
;
lcol=[10,11,12,13,14,15]
lthi=[6,6,6,6,6,4]
;
loadct,39
multi_plot,nrow=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,bold=0,font_size=16
endelse
def_1color,10,color='red'
def_1color,11,color='lpurple'
def_1color,12,color='mlblue'
def_1color,13,color='green'
def_1color,14,color='mdyellow'
def_1color,15,color='black'
def_1color,18,color='white'
def_1color,22,color='vlblue'
def_smearcolor,fromto=[18,22]
;
ndo=6
nyr=2000
alltime=findgen(nyr)
alldo=fltarr(ndo,nyr)*!values.f_nan
namedo=['Jones ','Mann  ','Briffa','NChron','Overpeck','Instr']
iord=[3,0,1,2,4,5]
;
for jdo = 0 , ndo-1 do begin
  ido=iord(jdo)
  fac=1.
  ;
  case ido of
    0: begin        ; Phil's reconstruction
      alltit="Jones' Northern Hemisphere temperature reconstruction"
      ; Period to consider
      perst=1000
      peren=1992
      openr,1,'../tree5/phil_nhrecon.dat'
      nyr=992
      rawdat=fltarr(4,nyr)
      readf,1,rawdat,format='(I5,F7.2,I3,F7.2)'
      close,1
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(3,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)
      ; Convert from normalised values to deg C relative to 1961-1990
;      ts=ts*0.521 -0.1134       ; via Phil's variance matching (vs. NH all)
      ts=ts*0.3856-0.1112       ; via regression vs. NH land>20
    end
    1: begin        ; Mike Mann's reconstruction (now use his 1000 yr one)
      alltit="Mann's Northern Hemisphere temperature reconstruction"
      ; Period to consider
      perst=1000
      peren=1980
      openr,1,'../tree5/mann_nhrecon1000.dat'
      nyr=981
      headdat=' '
      rawdat=fltarr(2,nyr)
;      readf,1,headdat
      readf,1,rawdat           ;,format='(I6,F11.7)'
      close,1
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
;      ts=ts(kl)-0.12            ; convert to oC wrt 1961-90 (vs. NH all)
      ts=ts(kl)*1.0641-0.0764   ; convert to oC wrt 1961-90 (vs. NH land>20)
    end
    2: begin        ; Age-banded MXD
      alltit="Age-banded density NH growing-season reconstruction"
      ; Period to consider
      perst=1402
      peren=1960
      fac=0.0       ; do not smooth it any further!!!
;      restore,filename='../treeharry/densadj_all(330).idlsave'
;      timey=x
;          ; CONVERSION FACTORS FOR AGE-BANDED MXD, BY REGRESSION ON INSTR.
;      ts=densadj*0.156525   ; converts it from density to temperature anom
      timey=newagetime
      ts=newagets
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)
;      ts=ts(kl)-0.140369   ; to convert it oC wrt 1961-90
    end
    3: begin         ; Torn+Yama+Taim
      perst=1
      peren=1993
      openr,2,'tornyamataim.ave'
      readf,2,nnn
      rawdat=fltarr(2,nnn)
      readf,2,rawdat
      close,2
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)*0.1342-0.2761    ; to convert it oC wrt 1961-90
      ;
    end
    4: begin         ; Overpeck
      perst=1600
      peren=1990
      fac=0.2        ; multiply filter by this because record is already 5-yrs
      openr,2,'overpeck_arctic.dat'
      headst=strarr(2)
      readf,2,headst
      readf,2,nnn
      rawdat=fltarr(2,nnn)
      readf,2,rawdat
      close,2
      timey=reverse(reform(rawdat(0,*)))
      ts=reverse(reform(rawdat(1,*)))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)*0.3352-0.0802    ; to convert it oC wrt 1961-90
      ;
    end
    5: begin         ; Instrumental NH land > 20N, Apr-Sep
      perst=1871
      peren=1997
      openr,2,'../treeharry/nhland20_amjjas.dat'
      readf,2,nnn
      rawdat=fltarr(2,nnn)
      readf,2,rawdat
      close,2
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)
      ;
    end
  endcase
  ;
  ; Now plot the results
  ;
  if fac gt 0. then filter_cru,thalf*fac,/nan,tsin=ts,tslow=tslow $
               else tslow=ts
  ;
  if jdo eq 0 then begin
    plot,timey,tslow,/nodata,$
      xstyle=1,xrange=[1000,2000],xtitle='Year  (AD)',$
      /ystyle,ytitle='Temperature anomaly  (!Uo!NC wrt 1961-90)',$
      yrange=[-0.75,0.25]
;      yrange=[-0.61,0.25]
    ttt=newagetime
    tts=newagets
    tse=newagese
    tkk=where((ttt ge 1402) and (ttt le 1960))
    ttt=ttt(tkk) & tts=tts(tkk) & tse=tse(tkk)
    xfill=[ttt,reverse(ttt)]
    yfill=[tts-tse*2.,reverse(tts+tse*2.)]
    kl=where(finite(yfill),nkeep)
    yfill=yfill(kl)
    xfill=xfill(kl)
    polyfill,xfill,yfill,color=19,noclip=0
    xfill=[ttt,reverse(ttt)]
    yfill=[tts-tse,reverse(tts+tse)]
    kl=where(finite(yfill),nkeep)
    yfill=yfill(kl)
    xfill=xfill(kl)
    polyfill,xfill,yfill,color=21,noclip=0
    oplot,!x.crange,[0.,0.],linestyle=1
  endif
  ;
  oplot,timey,tslow,thick=lthi(ido),color=lcol(ido)
print,min(tslow,/nan)
  ;
  ; Store timeseries for later cross-correlation
  ;
  ist=where(alltime eq timey(0))
  alldo(ido,ist(0):ist(0)+n_elements(ts)-1)=ts(*)
  ;
endfor
;
legpos=convert_coord([1025],[-0.45],/data,/to_normal)
legend,position=legpos,$
  ['Jones et al.','Mann et al.','Overpeck et al.','Briffa et al.',$
    'This study (+ errors)','Observations'],$
  thick=[6,6,6,6,6,4],color=[10,11,14,13,12,15]
;
if docorr ne 0 then begin
ndo=4
for kkk = 1 , 1 do begin
  if kkk eq 0 then yrst=1000 else yrst=1402
  print
  print,'Analysis period:',yrst,1960
  print
  print,'TS1     TS2     Raw   <10yr   >10yr     Raw   <50yr   >50yr'
for ido = 0 , ndo-2 do begin
  for jdo = ido+1 , ndo-1 do begin
    x=reform(alldo(ido,*))
    y=reform(alldo(jdo,*))
    allr1=mkcorrelation(x,y,alltime,filter=10.,refperiod=[yrst,1960])
    allr=mkcorrelation(x,y,alltime,filter=thalf,refperiod=[yrst,1960])
    print,namedo(ido),namedo(jdo),allr1,allr,format='(2A8,6F8.2)'
  endfor
endfor
endfor
endif
;
end
