;
; Writes an ASCII file with data (gridded, not extended, not corrected,
; not ABD-adjusted, calibrated) for input to the Arctic synthesis update.
;
doinfill=0         ; use PCR-infilled data or not?
doabd=0            ; use ABD-adjusted data or not?
docorr=0           ; use corrected version or not? (uncorrected only available
                   ;                                for doinfill=doabd=0)
missval=-9.99
;
; Get the calibrated data
;
print,'Reading reconstructions'
if doabd eq 0 then begin
  if doinfill eq 0 then begin
    print,'THIS IS THE ONE I WANT!'
    restore,'calibmxd5.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
    if docorr eq 0 then fdcalibc=fdcalibu
  endif else begin
    restore,'calibmxd5_pcr.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
  endelse
endif else begin
  if doinfill eq 0 then begin
    restore,'../mann/calibmxd5_abdlow.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
    if docorr eq 0 then fdcalibc=fdcalibu
  endif else begin
    restore,'../mann/calibmxd5_abdlow_pcr.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
  endelse
endelse
;
; Lets plot the location of the boxes with data
;
boxlist=where(total(finite(fdcalibc),3) gt 0,nbox)
fdmask=fltarr(g.nx,g.ny)*!values.f_nan
fdmask[boxlist]=20
inter_boxfd,fdmask,g.x,g.y,map=def_map(/npolar)
;
; Let's plot the average of all plot
;
pause
xxx=reform(fdcalibc,g.nx*g.ny,mxdnyr)
plot,total(xxx,1,/nan)/float(total(finite(xxx),1))
;
; Now lets output the data to an ASCII file
;
ml=where(finite(fdcalibc) eq 0,nmiss)
fdcalibc[ml]=missval
;
ndec=ceil(mxdnyr/10.)
;
if doabd ne 0 then begin
  openw,1,'osborn_briffa_WITHLOWFREQ.dat'
endif else begin
  openw,1,'osborn_briffa.dat'
endelse
printf,1,'These are gridded, calibrated estimates of mean warm-season'
printf,1,'(April-September) temperature anomalies (degC with respect to the'
printf,1,'1961-1990 mean), based on tree-ring density records from within'
printf,1,'each grid box (all boxes contained at least 1 tree-ring'
printf,1,'chronology).'
if doabd ne 0 then begin
  printf,1,'THIS VERSION CONTAINS GRID-BOX TIME SERIES WHOSE LOW-FREQUENCIES'
  printf,1,'HAVE BEEN "RESTORED" TO MATCH THOSE OBTAINED AT REGIONAL SCALES'
  printf,1,'BY BRIFFA ET AL. (2001) JGR, USING AGE-BAND DECOMPOSITION (ABD).'
endif
printf,1
printf,1,nbox,format='("Number of boxes:",I5)'
printf,1,missval,format='("Missing value:",F7.2)'
printf,1
for ix = 0 , g.nx-1 do begin
  for iy = 0 , g.ny-1 do begin
    if finite(fdmask[ix,iy]) then begin
      printf,1,g.x[ix],g.y[iy],format='(2F10.4,"  Longitude & Latitude")'
      for idec = 0 , ndec-1 do begin
        iyr=idec*10
        jyr=(iyr+9) < (mxdnyr-1)
        printf,1,mxdyear[[iyr,jyr]],fdcalibc[ix,iy,iyr:jyr],$
          format='(I4,":",I4,10F7.2)'
      endfor
    endif
  endfor
endfor
close,1
flush,-1
;
end
