;
; Writes an ASCII file with data (gridded, yes/no extended, corrected,
; yes/no ABD-adjusted, calibrated) for input to the Arctic synthesis update.
;
doinfill=1         ; use PCR-infilled data or not?
doabd=1            ; use ABD-adjusted data or not?
docorr=1           ; use corrected version or not? (uncorrected only available
                   ;                                for doinfill=doabd=0)
missval=-9.99
;
; Get the calibrated data
;
print,'Reading reconstructions'
if doabd eq 0 then begin
  if doinfill eq 0 then begin
    restore,'calibmxd5.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
    if docorr eq 0 then fdcalibc=fdcalibu
  endif else begin
    restore,'calibmxd5_pcr.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
  endelse
endif else begin
  if doinfill eq 0 then begin
    restore,'../mann/calibmxd5_abdlow.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
    print,'PROBABLY WANT THIS ONE'
    if docorr eq 0 then fdcalibc=fdcalibu
  endif else begin
    restore,'../mann/calibmxd5_abdlow_pcr.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
  endelse
endelse
;
; Lets plot the location of the boxes with data
;
loadct,39
boxlist=where(total(finite(fdcalibc),3) gt 0,nbox)
fdmask=fltarr(g.nx,g.ny)*!values.f_nan
fdmask[boxlist]=20
inter_boxfd,fdmask,g.x,g.y,map=def_map(/npolar)
;
; Now lets output the Sweden data to an ASCII file
;
kxl=where((g.x ge 10.) and (g.x le 23.),nkx)
kyl=where((g.y ge 55.) and (g.y le 70.),nky)
;
ml=where(finite(fdcalibc) eq 0,nmiss)
fdcalibc[ml]=missval
;
ndec=ceil(mxdnyr/10.)
;
if doabd ne 0 then begin
  openw,1,'osborn_briffa_WITHLOWFREQ.sweden.dat'
endif else begin
  openw,1,'osborn_briffa.dat'
endelse
printf,1,'These are gridded, calibrated estimates of mean warm-season'
printf,1,'(April-September) temperature anomalies (degC with respect to the'
printf,1,'1961-1990 mean), based on tree-ring density records.'
;
printf,1
printf,1,'IMPORTANT NOTE:'
printf,1,'The data after 1960 should not be used.  The tree-ring density'
printf,1,'records tend to show a decline after 1960 relative to the summer'
printf,1,'temperature in many high-latitude locations.  In this data set'
printf,1,'this "decline" has been artificially removed in an ad-hoc way, and'
printf,1,'this means that data after 1960 no longer represent tree-ring
printf,1,'density variations, but have been modified to look more like the
printf,1,'observed temperatures.'
;
if doabd ne 0 then begin
  printf,1
  printf,1,'IMPORTANT NOTE:'
  printf,1,'This version contains grid-box time series whose low-frequencies'
  printf,1,'have been "restored" to match those obtained at regional scales'
  printf,1,'by Briffa et al. (2001, J. Geophys. Res.), using Age-Band Decomposition (ABD).'
endif
;
if doinfill ne 0 then begin
  printf,1
  printf,1,'IMPORTANT NOTE:'
  printf,1,'Not all of these values come directly from tree-ring density'
  printf,1,'measurements in the grid box itself.  Some grid boxes do not'
  printf,1,'have tree-ring density data in them, while others have data only'
  printf,1,'for some periods.  But if the temperatures can be skilfully'
  printf,1,'estimated using tree-ring density data from surrounding grid boxes'
  printf,1,'then this has been done, to create the more fully complete data'
  printf,1,'set provided here.'
endif
;
printf,1
printf,1,missval,format='("Missing value:",F7.2)'
printf,1
for jx = 0 , nkx-1 do begin
  ix=kxl[jx]
  for jy = 0 , nky-1 do begin
    iy=kyl[jy]
    if finite(fdmask[ix,iy]) then begin
      plots,g.x[ix],g.y[iy],psym=def_sym(10),color=240
      printf,1,g.x[ix],g.y[iy],format='(2F10.4,"  Longitude & Latitude")'
      for idec = 0 , ndec-1 do begin
        iyr=idec*10
        jyr=(iyr+9) < (mxdnyr-1)
        printf,1,mxdyear[[iyr,jyr]],fdcalibc[ix,iy,iyr:jyr],$
          format='(I4,":",I4,10F7.2)'
      endfor
    endif
  endfor
endfor
close,1
flush,-1
;
end
