;
; Plots the observed SLP, TEMP and PREC signals that go with the observed
; summer SLP modes.  The signals are the regression coefficients between SLP
; anomalies, TEMP anomalies and PREC % anomalies, and the normalised (over
; 1961-90) principal component timeseries of each mode.
; FOR SLP, IT IS THE CORRELATION NOT REGRESSION COEFF.
;
restore,filename='obs_stp_modes.idlsave'
;  slparp,temparp,precarp,modets,timey,nyr,nvar,varname
;  gslp,gtemp,gprec,nretain
;
loadct,39
multi_plot,nrow=2,ncol=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
;
map=def_map(/npolar) & map.limit(0)=15.
labels=def_labels(/off)
sm=def_sm() & sm.thresh=0.1
coast=def_coast(/get_device) & coast.double=0 & coast.fill=1
coast.fillcolor=10
def_1color,10,color='vlgreen'
def_1color,20,color='deepblue'
def_1color,21,color='red'
;
for iretain = 2 , 2 do begin
  titn=string(iretain+1,format='(I2)')
  ;
  ; Timeseries first
  ;
  pause
  yyy=reform(modets(*,iretain))
;  plot,timey,yyy,$
;    /xstyle,xtitle='Year',$
;    ytitle='Normalised amplitude',ymargin=[10,10],$
;    title='Summer mode #'+titn
;  oplot,!x.crange,[0.,0.],linestyle=1
;  filter_cru,10.,/nan,tsin=yyy,tslow=tslow
;  oplot,timey,tslow,thick=5
  ;
  ; Now plot SLP pattern
  ;
  fd=reform(slparp(*,*,iretain))
  levs=findgen(8)*0.1+0.2
  levs=[-reverse(levs),levs]
  nlev=n_elements(levs)
  c_labels=[1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1]
  c_thick=[replicate(5,(nlev/2)-1),2,2,replicate(5,(nlev/2)-1)]
  c_colors=[replicate(20,nlev/2),replicate(21,nlev/2)]
  sm.on=1
  ;
  inter_confd,fd,gslp.xlon,gslp.ylat,$
    coast=coast,map=map,labels=labels,sm=sm,$
    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
    miss_grey='white',c_colors=c_colors
  ;
  !p.ticklen=0.03
  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
  yr=!y.region
  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
  xloc=0.5*total(!x.region)
  xyouts,xloc,yloc,/normal,align=0.5,$
    '(a) Mode #'+titn+' vs. SLP anomalies'
  xyouts,xloc,yr(0)+0.05,/normal,align=0.5,$
    'Correlations',charsize=!p.charsize*0.7
  ;
  ; Now plot TEMP pattern
  ;
  fd=reform(temparp(*,*,iretain))
  levs=findgen(8)*0.1+0.1
  levs=[-reverse(levs),levs]
  nlev=n_elements(levs)
  c_labels=replicate(1,nlev)
  c_thick=[replicate(5,(nlev/2)-1),2,2,replicate(5,(nlev/2)-1)]
  c_colors=[replicate(20,nlev/2),replicate(21,nlev/2)]
  sm.on=1
  ;
  inter_confd,fd,gtemp.xlon,gtemp.ylat,$
    coast=coast,map=map,labels=labels,sm=sm,$
    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
    miss_grey='white',c_colors=c_colors
  ;
  !p.ticklen=0.03
  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
  yr=!y.region
  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
  xloc=0.5*total(!x.region)
  xyouts,xloc,yloc,/normal,align=0.5,$
    '(b) Mode #'+titn+' vs. temperature anomalies'
  xyouts,xloc,yr(0)+0.05,/normal,align=0.5,$
    'Correlations',charsize=!p.charsize*0.7
  ;
  ; Now plot PREC pattern
  ;
  fd=reform(precarp(*,*,iretain))
  levs=findgen(8)*0.1+0.1
  levs=[-reverse(levs),levs]
  nlev=n_elements(levs)
  c_labels=replicate(1,nlev)
  c_thick=[replicate(2.,nlev/2),replicate(5.,nlev/2)]
  c_colors=[replicate(!p.color,(nlev/2)-1),20.]
  c_colors=[c_colors,reverse(c_colors)]
  sm.on=1
  ;
;  inter_confd,fd,gprec.xlon,gprec.ylat,$
;    coast=coast,map=map,labels=labels,sm=sm,$
;    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
;    miss_grey='white',c_linestyle=c_linestyle
  ;
;  !p.ticklen=0.03
;  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
;  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
;  yr=!y.region
;  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
;  xloc=0.5*total(!x.region)
;  xyouts,xloc,yloc,/normal,align=0.5,$
;    'Mode #'+titn+' vs. precipitation anomalies'
;  xyouts,xloc,yr(0),/normal,align=0.5,$
;    'Correlations',charsize=!p.charsize*0.7
  ;
endfor
;
end
