;
; Plots the observed SLP, TEMP and PREC signals that go with the observed
; summer SLP modes.  The signals are the regression coefficients between SLP
; anomalies, TEMP anomalies and PREC % anomalies, and the normalised (over
; 1961-90) principal component timeseries of each mode.
; FOR SLP, IT IS THE CORRELATION NOT REGRESSION COEFF.
;
docol=0        ; 0=B&W 1=color
;
restore,filename='obs_stp_modes.idlsave'
;  slparp,temparp,precarp,modets,timey,nyr,nvar,varname
;  gslp,gtemp,gprec,nretain
;
loadct,39
multi_plot,nrow=3,ncol=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=10
endelse
;
map=def_map(/npolar) & map.limit(0)=15.
labels=def_labels(/off)
sm=def_sm() & sm.thresh=0.1 & sm.wid=2.
coast=def_coast(/get_device) & coast.double=0 & coast.fill=1
coast.fillcolor=10
if docol eq 0 then begin
  def_1color,10,color='palegrey'
  def_1color,20,color='mdgrey'
  def_1color,21,color='black'
  def_1color,22,color='black'
endif else begin
  def_1color,10,color='vlgreen'
  def_1color,20,color='mdgrey'
  def_1color,21,color='deepblue'
  def_1color,22,color='red'
endelse
;
;nretain=4
;kretain=[1,2,6,8]
nretain=nretain < 9
kretain=indgen(nretain)
kpve=[11,11,9,8,7,7,6,6]
partno='('+['a','b','c','d','e','f','g','h','i','j','k']+')'
for jretain = 0 , nretain-1 do begin
  iretain=kretain(jretain)
  titn=string(iretain+1,format='(I1)')
  tit1='  '+string(kpve(iretain),format='(I2)')+'%'
  ;
  ; Timeseries first
  ;
;  pause
;  yyy=reform(modets(*,iretain))
;  plot,timey,yyy,$
;    /xstyle,xtitle='Year',$
;    ytitle='Normalised amplitude',ymargin=[10,10],$
;    title='Summer mode #'+titn+tit1
;  oplot,!x.crange,[0.,0.],linestyle=1
;  filter_cru,10.,/nan,tsin=yyy,tslow=tslow
;  oplot,timey,tslow,thick=5
  ;
  ; Now plot SLP pattern
  ;
  fd=reform(slparp(*,*,iretain))
  levs=findgen(8)*0.1+0.2
  levs=[-reverse(levs),levs]
  nlev=n_elements(levs)
  c_labels=replicate(1,nlev)
  c_thick=[replicate(2.,nlev/2),replicate(5.,nlev/2)]
  if docol eq 1 then c_thick=replicate(4.,nlev)
  c_colors=[replicate(21,nlev/2),replicate(22,nlev/2)]
  sm.on=1
  ;
  inter_confd,fd,gslp.xlon,gslp.ylat,$
    coast=coast,map=map,labels=labels,sm=sm,$
    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
    miss_grey='white',c_colors=c_colors
  ;
  !p.ticklen=0.03
  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
  yr=!y.region
  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
  xloc=0.5*total(!x.region)
  xyouts,xloc,yloc,/normal,align=0.5,$
    partno(jretain)+' Mode #'+titn+tit1
;  yloc=normtop(0)+0.3*(yr(0)-normtop(0))
;  xyouts,xloc,yloc,/normal,align=0.5,$
;    'Correlations',charsize=!p.charsize*0.7
  ;
  ; Now plot TEMP pattern
  ;
;  fd=reform(temparp(*,*,iretain))
;  levs=findgen(8)*0.1+0.1
;  levs=[-reverse(levs),levs]
;  nlev=n_elements(levs)
;  c_labels=replicate(1,nlev)
;  if docol eq 0 then begin
;    c_thick=[replicate(2.,nlev/2),replicate(5.,nlev/2)]
;;    c_linestyle=[0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0]
;    c_linestyle=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
;  endif else begin
;    c_thick=[5,5,5,5,5,5,5,2,2,5,5,5,5,5,5,5]
;    c_linestyle=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
;  endelse
;  c_colors=[replicate(21,nlev/2),replicate(22,nlev/2)]
;  sm.on=1
  ;
;  inter_confd,fd,gtemp.xlon,gtemp.ylat,$
;    coast=coast,map=map,labels=labels,sm=sm,$
;    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
;    miss_grey='white',c_linestyle=c_linestyle,c_colors=c_colors
  ;
;  !p.ticklen=0.03
;  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
;  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
;  yr=!y.region
;  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
;  xloc=0.5*total(!x.region)
;  xyouts,xloc,yloc,/normal,align=0.5,$
;    'Mode #'+titn+' vs. temperature anomalies'
;  xyouts,xloc,yr(0),/normal,align=0.5,$
;    'Correlations',charsize=!p.charsize*0.7
  ;
  ; Now plot PREC pattern
  ;
;  fd=reform(precarp(*,*,iretain))
;  levs=findgen(8)*0.1+0.1
;  levs=[-reverse(levs),levs]
;  nlev=n_elements(levs)
;  c_labels=replicate(1,nlev)
;  if docol eq 0 then begin
;    c_thick=[replicate(2.,nlev/2),replicate(5.,nlev/2)]
;;    c_linestyle=[0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0]
;    c_linestyle=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
;  endif else begin
;    c_thick=[5,5,5,5,5,5,5,2,2,5,5,5,5,5,5,5]
;    c_linestyle=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
;  endelse
;  c_colors=[replicate(21,nlev/2),replicate(22,nlev/2)]
;  sm.on=1
  ;
;  inter_confd,fd,gprec.xlon,gprec.ylat,$
;    coast=coast,map=map,labels=labels,sm=sm,$
;    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
;    miss_grey='white',c_linestyle=c_linestyle,c_colors=c_colors
  ;
;  !p.ticklen=0.03
;  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
;  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
;  yr=!y.region
;  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
;  xloc=0.5*total(!x.region)
;  xyouts,xloc,yloc,/normal,align=0.5,$
;    'Mode #'+titn+' vs. precipitation anomalies'
;  xyouts,xloc,yr(0),/normal,align=0.5,$
;    'Correlations',charsize=!p.charsize*0.7
  ;
endfor
;
end
