;
; Plots a map showing location of all MXD chronologoes
; *** NOW REMOVES MXD SERIES WITH POOR CORRELATIONS WITH LOCAL SUMMER TEMP ***
; BUT, there will still be some series that are not in grid boxes with data
; back to 1697, and hence will not be used in the Holocene part 2 paper!
; SO, we'll also overlay the grid boxes that are used in the paper.
;
cutr=0.22      ; a 'best' series is based on sites with local r >= cutr (0.22)
iseas=18       ; Apr-Sep for MXD
;
; First read in the MXD data
;
restore,filename='../allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
; Next read in the correlations between MXD and local climate
;
restore,filename='../mxd_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon,allp,moir,moir2
;
; Remove any that are almost entirely missing, or that
; aren't well correlated with their local summer temperature
;
nkeep=0
for i = 0 , nchron-1 do begin
  if allr(i,iseas,1) ge cutr then begin
    dummy=where(finite(mxd(*,i)),ngot)
    if ngot ge 20 then begin
      if nkeep eq 0 then kl=i else kl=[kl,i]
      nkeep=nkeep+1
    endif
  endif
endfor
print,'Had',nchron,' chronologies, but',nchron-nkeep,' are empty or poor'
statlon=statlon(kl)
statlat=statlat(kl)
;
; Now let's get the gridded data set, and work out which boxes have complete
; data for 1697-1976, as used in Holocene part 2 paper.
;
useper=[1697,1976]
;
; Restore MXD gridded dataset
;
print,'Reading in MXD data'
restore,filename='calibmxd5.idlsave'
;  g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
;
; Extract required period and locate boxes with complete data
;
print,'Finding spatial and temporal coverage'
kmxd=where((mxdyear ge useper(0)) and (mxdyear le useper(1)),mxdnyr)
mxdyear=mxdyear(kmxd)
fdcalibu=fdcalibu(*,*,kmxd)
fdmask=total(fdcalibu,3)*0.+1.
kmask=where(finite(fdmask),nmask)
print,'NYR=',mxdnyr,'  NBOX=',nmask
;
; Now let's get rid of any chronologies that aren't in a box that's being
; used.
;
statmask=fltarr(nkeep)
for i = 0 , nkeep-1 do begin
  xl=statlon[i]
  yl=statlat[i]
  xdiff=abs(g.x-xl)
  dummy=min(xdiff,iwant)
  ydiff=abs(g.y-yl)
  dummy=min(ydiff,jwant)
  if finite(fdmask[iwant,jwant]) then statmask[i]=1
endfor
print,'Chronologies user=',total(statmask)
;
loadct,39
def_1color,20,color='vlgrey'
def_1color,50,color='mdgrey'
multi_plot,nrow=1
if !d.name eq 'X' then begin
  window,xsize=700,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device)
coast.thick=[1,2]
labels=def_labels(/off)
;
levs=[0.5,1.5]
cols=[50]
;
inter_boxfd,fdmask,g.x,g.y,$
  map=map,coast=coast,labels=labels,$
  levels=levs,c_colors=cols

;inter_boxfd,/nodata,map=map,coast=coast,labels=labels
;  title='Location of tree-ring density chronologies'
;map_continents,/coasts,/fill_continents,color=20
;map_continents,/coasts
;map_continents,/countries,mlinestyle=1,mlinethick=0.5
map_plots,findgen(361)-180.,replicate(25.,361)
;
cpl_usersym,/circle,/fill
for i = 0 , nkeep-1 do begin
  if statmask[i] eq 1 then plots,statlon[i],statlat[i],psym=8,symsize=0.7
endfor
cpl_usersym,/circle
for i = 0 , nkeep-1 do begin
  if statmask[i] eq 1 then plots,statlon[i],statlat[i],psym=8,symsize=0.7,$
    color=!p.background
endfor
;
end
