;
; Reads in the gridded MXD data, and outputs the (non-infilled)
; version to an ascii file, extracting only those grid boxes
; that have at least some data.
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnadd='mxd'
    end
  1: begin
    fnadd='trw'
    end
endcase
titadd=strupcase(fnadd)
;
restore,fnadd+'_infill.idlsave'
; Gets: ntime,maxbox,boxdens,g,keepi,keepj,timey
;       baselist,nbase,mxdfd,mxdyear,mxdnyr,mxdfd2,beglist,endlist
;
numfd=total(finite(mxdfd),3)
kl=where(numfd gt 0,nbox)
print,'Number of boxes with some MXD data = ',nbox
mxdfd=reform(mxdfd,g.nx*g.ny,mxdnyr)
mxdlist=mxdfd(kl,*)
ml=where(finite(mxdlist) eq 0,nmiss)
if nmiss gt 0 then mxdlist(ml)=-9.99
;
openw,1,'schweingruber_mxd_grid.dat'
printf,1,mxdlist,format='(115F8.3)'
close,1
;
end
