;
; Plots Apr-Sep means of Azores minus SW Iceland NAO index
;
loadct,39
multi_plot,nrow=4,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
;
; Read in all monthly index values
;
print,'Reading in NAO index'
ncid=ncdf_open('/cru/u2/f055/data/obs/index/nc/nao_azonorm-swicenorm.nc')
tsmon=crunc_rddata(ncid,tst=[1922,0],tend=[1998,11],grid=g,info=i)
ncdf_close,ncid
;
; Reform into separate timeseries for each month, then mean the Apr-Sep ones
;
nmon=12
nyr=g.nt/nmon
tsmon=reform(tsmon,nmon,nyr)
tsmon=tsmon(3:8,*)
seasts=total(tsmon,1)/6.    ; Ignore NaN, since any missing ==> season missing
timey=findgen(nyr)+1922
;
filter_cru,10.,/nan,tsin=seasts,tslow=tslow
plot,timey,seasts,$
    /xstyle,xtitle='Year',$
    ytitle='Apr-Sep mean index value',$
    title='Azores minus Iceland NAO index'
oplot,!x.crange,[0.,0.],linestyle=1
oplot,timey,tslow,thick=3
;
save,filename='nao_summer.idlsave',timey,seasts,tslow
;
end
