;
; Test's my implementation of Thornthwaite's PE calculation
;
; Gatwick first
;
tmon1=[3.5,3.8,5.7,8.0,11.3,14.4,16.5,16.1,13.8,10.7,6.4,4.5]
vmon1=0.5*([81.,76,69,64,62,60,60,62,67,73,78,82]+$
           [91.,89,91,90,92,92,93,95,96,95,93,91])
;vmon1= [91.,89,91,90,92,92,93,95,96,95,93,91]
emon1=thornthwaite(tmon1,51.)       ; 51N is the latitude
imon1=ivanov(tmon1,vmon1)         ; relative humidities given
;
; Madrid next
;
tmon2=[6.1,7.5,10.,12.2,16.,20.7,24.4,23.9,20.5,14.8,9.4,6.4]
vmon2=[7.0,7.1,7.1,8.1,9.7,11.6,12.,12.,12.1,10.8,8.7,7.4]
emon2=thornthwaite(tmon2,40.)       ; 40N is the latitude
imon2=ivanov(tmon2,vmon2,/vapour)   ; vapour pressures given
;
; Hatanga next
;
tmon3=[-33.8,-32.,-27.,-18.1,-7.7,4.6,12.5,9.1,1.6,-12.3,-26.4,-29.7]
vmon3=[0.4,0.5,0.7,1.4,2.9,6.4,9.8,8.9,5.9,2.4,0.8,0.6]
emon3=thornthwaite(tmon3,65.)       ; 72N is the latitude (but cutoff at 65N)
imon3=ivanov(tmon3,vmon3,/vapour)   ; vapour pressures given
;
; Salehard
;
;tmon3=[-24.8,-23.6,-16.4,-9.9,-1.8,7.8,14.4,10.5,5.1,-4.9,-15.5,-20.7]
;emon3=thornthwaite(tmon3,65.)       ; 66N is the latitude (but cutoff at 65N)
;
; Perm
;
;tmon3=[-15.1,-12.5,-5.2,3.1,10.1,15.5,18.3,15.,9.4,1.4,-5.6,-11.4]
;emon3=thornthwaite(tmon3,57.)       ; 57N is the latitude
;
; Vanavara (60N 100E)
;
;tmon3=[-29.6,-27.,-15.1,-4.2,5.2,13.7,17.2,13.1,5.4,-5.2,-18.9,-27.5]
;emon3=thornthwaite(tmon3,60.)       ; 60N is the latitude
;
multi_plot,nrow=2
window,ysize=750
loadct,39
;
plot,tmon1,psym=10,yrange=[-35,30],/ystyle
oplot,tmon2,thick=3,psym=10
oplot,tmon3,thick=5,psym=10
;
plot,emon1,psym=10,yrange=[0,300],/ystyle
oplot,emon2,thick=3,psym=10
oplot,emon3,thick=5,psym=10
oplot,imon1,psym=10,color=200
oplot,imon2,thick=3,psym=10,color=200
oplot,imon3,thick=5,psym=10,color=200
;
legend,thick=[1,1,3,5],linestyle=[-1,0,0,0],$
  ['Thornthwaite formula','Gatwick ANN PE='+string(total(emon1),format='(I5)'),$
   'Madrid ANN PE='+string(total(emon2),format='(I5)'),$
   'Hatanga ANN PE='+string(total(emon3),format='(I5)')]
;
legend,thick=[1,1,3,5],linestyle=[-1,0,0,0],color=[!p.color,200,200,200],$
  ['Ivanov formula','Gatwick ANN PE='+string(total(imon1),format='(I5)'),$
   'Madrid ANN PE='+string(total(imon2),format='(I5)'),$
   'Hatanga ANN PE='+string(total(imon3),format='(I5)')],$
  position=[0.65,0.45]
;
end
