#! /usr/bin/perl

# immediate output of debug prints
$| = 1;

# @INC = ('c:\html\climategate','.');

# print "before 'require splitcsv.pl'\n";
require "splitcsv.pl";

print "dbg: cmd='perl -w $0 " . join(' ', @ARGV) . "'\n";

$dbg=0;  # for debug prints
$quiet = 0;  # we don't actually use the -q ("quiet") command line parameter, but we might someday
while (($#ARGV >= 0) && ('-' eq substr($ARGV[0],0,1))) {
   if ('-d' eq $ARGV[0]) {
      $dbg++;  # turn on debug prints
   } elsif ('-q' eq $ARGV[0]) {
      $quiet = 1;
   } else {
      printf "ERROR: unrecognized command-line option: '%s'\n", $ARGV[0];
      exit 1;
   }
   shift @ARGV;
}

# $start_time = time;
# # print "before 'require ctime.pl'\n";
# require 'ctime.pl';  # see the -P and -I option in perl.man

$num_args = $#ARGV+1;

if ($num_args != 2) {
 print "degrees_minutes_to_fractional_degrees.pl -- convert \"21,30 W\" to \"-21.5\"\n" .
       "in latitude and longitude fields\n" .
       "\n" .
       "Usage:\n" .
       "\n" .
       "   perl -w $0 input.csv output.csv\n" .
       "\n";
       exit 1;
}

$inpfile = $ARGV[0];
$outpfile = $ARGV[1];

if (!open(INP,"<$inpfile")) {
   printf "ERROR: could not open '%s', $!\n", $inpfile;
   exit 1;
}
if (!open(OUTP,">$outpfile")) {
   printf "ERROR: could not create '%s', $!\n", $outpfile;
   exit 1;
}
print "reading '$inpfile' and writing '$outpfile'...\n";


if (0) {
  # read a spreadsheet record:
  $_ = <INP>;
  if (defined $_) {
     # we managed to read the header line
     chop $_;
     $_ =~ s/[\r\n]*$//;  # because 16-bit Perl lack chomp (to strip both cr and lf), we make sure here
  } else {
     print "ERROR: can't read $inpfile, $!\n";
     exit 1;
  }
  # Split header line into fields (the column headers):
  @hdrs = &split_csv( $_ );
  foreach $tm (@hdrs) {
     # remove quote marks:
     if ($tm =~ /^\"(.*)\"$/) {
        $tm = $1;
     }
     # make it lower-case:
     $tm =~ tr/A-Z/a-z/;
  }
}


# Read the spreadsheet records
$count_inp_lines = $count_outp_lines = 0;
while (<INP>) {
   $count_inp_lines++;
   chop;
   $_ =~ s/[\r\n]*$//;  # because Perl 4 lacks chomp (to strip both cr and lf), we make sure here

   # Split into fields.
   @sfields = &split_csv( $_ );
   $num_fields_with_content = 0;
   $first_field_is_only_field = 1;
   $fieldnumber = 0;
   foreach $fld (@sfields) {
      # get rid of leading and trailing whitespace in each field:
      if ($fld =~ /\s/) {
         $fld =~ s/^\s*//;  # strip leading whitespace, too.
         $fld =~ s/\s*$//;  # strip trailing blanks, tabs, cr, lf, etc.
         # get rid of any tabs, and collapse multiple spaces to one space:
         if ($fld =~ /\t|\s\s/) {
            $fld =~ s/\s+/ /g;
         }
      }
      if ('' ne $fld) {
         $num_fields_with_content++;
         if ($fieldnumber > 0) {
            $first_field_is_only_field = 0;
         }
      }
      # # upper-case each field value
      # $fld =~ tr/a-z/A-Z/;
      if ($fld =~ /^([0-9]+)\,([0-9][0-9\.]*)( |)([NSEW])$/) {
         # found a latitude or longitude
         $deg = $1;
         $min = $2;
         $dir = $4;
         $deg = $1 + ($2 / 60);
         if ($dir =~ /[SW]/) {
            $deg = -$deg;
         }
         # if (length($deg) > 10) {
         #    $deg = sprintf("%4.5f",$deg);
         # }
         $fld = $deg;
      }
      $fieldnumber++;
   }
   if (!$num_fields_with_content) {
      next;  # skip empty records
   }

   for ($i=0; $i<=$#sfields; $i++) {
      if ($i > 0) {
         print OUTP ",";
      }
      if ('' ne $sfields[$i]) {
         print OUTP '"' . $sfields[$i] . '"';
      }
   }
   print OUTP "\n";

   $count_outp_lines++;
}

print "read $count_inp_lines from '$inpfile'\n" .
      "wrote $count_outp_lines to '$outpfile'\n";

exit 0;

__END__

