#! /usr/bin/perl

# A function to split a record in CSV format into separate fields.
# (Compatible with both Perl4 and Perl5.)
#
# This file is UNCOPYRIGHTED, by David A. Burton, 2001-2010
# Cary, NC  USA
# +1-919-481-0149
# Email: http://www.burtonsys.com/email/
#
# You can use a "require" to pull this into another Perl program, like this:
#
#   @INC = ('.','..');
#   print "before 'require splitcsv.pl'\n";
#   require ".\\splitcsv.pl";
#   print "after 'require splitcsv.pl'\n";



# split a CSV record into fields, return the array of fields
sub split_csv {
  local(@fields);
  local($inp) = @_;
  local($fieldnum) = 0;
  local($field,$ndx);

  while (1) {
     $fieldnum++;
     $field = '';
     if ('"' eq substr($inp,0,1)) {
        #quoted field
        $inp = substr($inp,1);  #discard leading quote
        ($field,$inp) = split('"',$inp,2);
        if (!defined $inp) {
           # no terminating quote mark
           $inp = '';
        } else {
           # this loop is necessary to handle embedded doubled quote marks.
           # the split removed the first quote mark, so if the next character
           # in $inp is also a quote mark then they must have been doubled,
           # so we have to append the quote mark and the rest of the field:
           while ('"' eq substr($inp,0,1)) {
              # embedded doubled '"' represents a '"'
              $field .= '"';
              $inp = substr($inp,1);
              ($tmp,$inp) = split('"',$inp,2);
              $field .= $tmp;
              if (!defined $inp) {
                 # no terminating quote mark
                 $inp = '';
              }
           }
        }
     } else {
        #unquoted field
        $ndx = index($inp,',');
        if ($ndx >= 0) {
           # found a comma
           $field = substr($inp,0,$ndx);
           $inp = substr($inp,$ndx);
        } else {
           # no more commas, so this must be last field
           $field = $inp;
           $inp = '';
        }
     }
     push(@fields,$field);
     if ($inp eq '') {
        last;
     }
     if (',' eq substr($inp,0,1)) {
        $inp = substr($inp,1);  # discard comma
     } else {
        print STDERR "ERROR: record $. has quote mark within quoted field $fieldnum, or is missing a comma.\n";
        print STDERR "Rest of record is: '$inp'\n";
     }
  } #while
  return @fields;
} #split_csv

# return true value to 'require'
1;
