#!/usr/bin/perl

# 5x8 character bitmaps (7-bit ASCII).
# (Compatible with both Perl4 and Perl5.)
#
# This file is UNCOPYRIGHTED, by David A. Burton, 2001-2010
# Cary, NC  USA
# +1-919-481-0149
# Email: http://www.burtonsys.com/email/
#
# You can use a "require" to pull this into another Perl program, like this:
#
#   @INC = ('.','..');
#   require "5x8_bitmap_charset.pl";


# The data is mostly from the font file called "7x5 from Alice Campbell" here:
# http://www.piclist.com/techref/datafile/charsets.htm
# But I fixed up some of the characters to look a bit better.


$bitmap_chars_5x8 =

# 0x20 (space)
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .

# !
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x00" .
"\x00" .
"\x04" .
"\x00" .

# "
"\x0A" .
"\x0A" .
"\x0A" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .

# #
"\x0A" .
"\x0A" .
"\x1F" .
"\x0A" .
"\x1F" .
"\x0A" .
"\x0A" .
"\x00" .

# $
"\x04" .
"\x0F" .
"\x14" .
"\x0E" .
"\x05" .
"\x1E" .
"\x04" .
"\x00" .

# %
"\x18" .
"\x19" .
"\x02" .
"\x04" .
"\x08" .
"\x13" .
"\x03" .
"\x00" .

# &
"\x0C" .
"\x12" .
"\x14" .
"\x08" .
"\x15" .
"\x12" .
"\x0D" .
"\x00" .

# '
"\x0C" .
"\x04" .
"\x08" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .

# (
"\x02" .
"\x04" .
"\x08" .
"\x08" .
"\x08" .
"\x04" .
"\x02" .
"\x00" .

# )
"\x08" .
"\x04" .
"\x02" .
"\x02" .
"\x02" .
"\x04" .
"\x08" .
"\x00" .

# *
"\x00" .
"\x04" .
"\x15" .
"\x0E" .
"\x15" .
"\x04" .
"\x00" .
"\x00" .

# +
"\x00" .
"\x04" .
"\x04" .
"\x1F" .
"\x04" .
"\x04" .
"\x00" .
"\x00" .

# ,
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x0C" .
"\x0C" .
"\x04" .
"\x08" .

# -
"\x00" .
"\x00" .
"\x00" .
"\x1F" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .

# .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x0C" .
"\x0C" .
"\x00" .

# /
"\x00" .
"\x01" .
"\x02" .
"\x04" .
"\x08" .
"\x10" .
"\x00" .
"\x00" .

# 0
"\x0E" .
"\x11" .
"\x13" .
"\x15" .
"\x19" .
"\x11" .
"\x0E" .
"\x00" .

# 1
"\x04" .
"\x0C" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x0E" .
"\x00" .

# 2
"\x0E" .
"\x11" .
"\x01" .
"\x02" .
"\x04" .
"\x08" .
"\x1F" .
"\x00" .

# 3
"\x1F" .
"\x02" .
"\x04" .
"\x02" .
"\x01" .
"\x11" .
"\x0E" .
"\x00" .

# 4
"\x02" .
"\x06" .
"\x0A" .
"\x12" .
"\x1F" .
"\x02" .
"\x02" .
"\x00" .

# 5
"\x1F" .
"\x10" .
"\x1E" .
"\x01" .
"\x01" .
"\x11" .
"\x0E" .
"\x00" .

# 6
"\x06" .
"\x08" .
"\x10" .
"\x1E" .
"\x11" .
"\x11" .
"\x0E" .
"\x00" .

# 7
"\x1F" .
"\x01" .
"\x02" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x00" .

# 8
"\x0E" .
"\x11" .
"\x11" .
"\x0E" .
"\x11" .
"\x11" .
"\x0E" .
"\x00" .

# 9
"\x0E" .
"\x11" .
"\x11" .
"\x0F" .
"\x01" .
"\x02" .
"\x0C" .
"\x00" .

# :
"\x00" .
"\x0C" .
"\x0C" .
"\x00" .
"\x0C" .
"\x0C" .
"\x00" .
"\x00" .

# ;
"\x00" .
"\x0C" .
"\x0C" .
"\x00" .
"\x0C" .
"\x04" .
"\x08" .
"\x00" .

# <
"\x02" .
"\x04" .
"\x08" .
"\x10" .
"\x08" .
"\x04" .
"\x02" .
"\x00" .

# =
"\x00" .
"\x00" .
"\x1F" .
"\x00" .
"\x1F" .
"\x00" .
"\x00" .
"\x00" .

# >
"\x08" .
"\x04" .
"\x02" .
"\x01" .
"\x02" .
"\x04" .
"\x08" .
"\x00" .

# ?
"\x0E" .
"\x11" .
"\x01" .
"\x02" .
"\x04" .
"\x00" .
"\x04" .
"\x00" .

# @
"\x0E" .
"\x11" .
"\x01" .
"\x0D" .
"\x15" .
"\x15" .
"\x0E" .
"\x00" .

# A
"\x0E" .
"\x11" .
"\x11" .
"\x11" .
"\x1F" .
"\x11" .
"\x11" .
"\x00" .

# B
"\x1E" .
"\x09" .
"\x09" .
"\x0E" .
"\x09" .
"\x09" .
"\x1E" .
"\x00" .

# C
"\x0E" .
"\x11" .
"\x10" .
"\x10" .
"\x10" .
"\x11" .
"\x0E" .
"\x00" .

# D
"\x1E" .
"\x09" .
"\x09" .
"\x09" .
"\x09" .
"\x09" .
"\x1E" .
"\x00" .

# E
"\x1F" .
"\x10" .
"\x10" .
"\x1F" .
"\x10" .
"\x10" .
"\x1F" .
"\x00" .

# F
"\x1F" .
"\x10" .
"\x10" .
"\x1E" .
"\x10" .
"\x10" .
"\x10" .
"\x00" .

# G
"\x0E" .
"\x11" .
"\x10" .
"\x13" .
"\x11" .
"\x11" .
"\x0F" .
"\x00" .

# H
"\x11" .
"\x11" .
"\x11" .
"\x1F" .
"\x11" .
"\x11" .
"\x11" .
"\x00" .

# I
"\x0E" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x0E" .
"\x00" .

# J
"\x07" .
"\x02" .
"\x02" .
"\x02" .
"\x02" .
"\x12" .
"\x0C" .
"\x00" .

# K
"\x11" .
"\x12" .
"\x14" .
"\x18" .
"\x14" .
"\x12" .
"\x11" .
"\x00" .

# L
"\x10" .
"\x10" .
"\x10" .
"\x10" .
"\x10" .
"\x10" .
"\x1F" .
"\x00" .

# M
"\x11" .
"\x1B" .
"\x15" .
"\x15" .
"\x11" .
"\x11" .
"\x11" .
"\x00" .

# N
"\x11" .
"\x19" .
"\x19" .
"\x15" .
"\x13" .
"\x13" .
"\x11" .
"\x00" .

# O
"\x0E" .
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x0E" .
"\x00" .

# P
"\x1E" .
"\x11" .
"\x11" .
"\x1E" .
"\x10" .
"\x10" .
"\x10" .
"\x00" .

# Q
"\x0E" .
"\x11" .
"\x11" .
"\x11" .
"\x15" .
"\x12" .
"\x0D" .
"\x00" .

# R
"\x1E" .
"\x11" .
"\x11" .
"\x1E" .
"\x14" .
"\x12" .
"\x11" .
"\x00" .

# S
"\x0E" .
"\x11" .
"\x10" .
"\x0E" .
"\x01" .
"\x11" .
"\x0E" .
"\x00" .

# T
"\x1F" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x00" .

# U
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x0E" .
"\x00" .

# V
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x11" .
"\x0A" .
"\x04" .
"\x00" .

# W
"\x11" .
"\x11" .
"\x11" .
"\x15" .
"\x15" .
"\x1B" .
"\x11" .
"\x00" .

# X
"\x11" .
"\x11" .
"\x0A" .
"\x04" .
"\x0A" .
"\x11" .
"\x11" .
"\x00" .

# Y
"\x11" .
"\x11" .
"\x11" .
"\x0A" .
"\x04" .
"\x04" .
"\x04" .
"\x00" .

# Z
"\x1F" .
"\x01" .
"\x02" .
"\x04" .
"\x08" .
"\x10" .
"\x1F" .
"\x00" .

# [
"\x0E" .
"\x08" .
"\x08" .
"\x08" .
"\x08" .
"\x08" .
"\x0E" .
"\x00" .

# \
"\x00" .
"\x10" .
"\x08" .
"\x04" .
"\x02" .
"\x01" .
"\x00" .
"\x00" .

# ]
"\x0E" .
"\x02" .
"\x02" .
"\x02" .
"\x02" .
"\x02" .
"\x0E" .
"\x00" .

# ^
"\x04" .
"\x0A" .
"\x11" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .

# _
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x1F" .
"\x00" .

# `
"\x10" .
"\x08" .
"\x04" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .
"\x00" .

# a
"\x00" .
"\x00" .
"\x0E" .
"\x01" .
"\x0F" .
"\x11" .
"\x0F" .
"\x00" .

# b
"\x10" .
"\x10" .
"\x16" .
"\x19" .
"\x11" .
"\x11" .
"\x1E" .
"\x00" .

# c
"\x00" .
"\x00" .
"\x0E" .
"\x11" .
"\x10" .
"\x11" .
"\x0E" .
"\x00" .

# d
"\x01" .
"\x01" .
"\x0D" .
"\x13" .
"\x11" .
"\x11" .
"\x0F" .
"\x00" .

# e
"\x00" .
"\x00" .
"\x0E" .
"\x11" .
"\x1F" .
"\x10" .
"\x0E" .
"\x00" .

# f
"\x02" .
"\x05" .
"\x04" .
"\x0E" .
"\x04" .
"\x04" .
"\x04" .
"\x00" .

# g
"\x00" .
"\x00" .
"\x0D" .
"\x13" .
"\x13" .
"\x0D" .
"\x01" .
"\x0E" .

# h
"\x10" .
"\x10" .
"\x16" .
"\x19" .
"\x11" .
"\x11" .
"\x11" .
"\x00" .

# i
"\x04" .
"\x00" .
"\x0C" .
"\x04" .
"\x04" .
"\x04" .
"\x0E" .
"\x00" .

# j
"\x02" .
"\x00" .
"\x06" .
"\x02" .
"\x02" .
"\x02" .
"\x12" .
"\x0C" .

# k
"\x08" .
"\x08" .
"\x09" .
"\x0A" .
"\x0C" .
"\x0A" .
"\x09" .
"\x00" .

# l
"\x0C" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x04" .
"\x0E" .
"\x00" .

# m
"\x00" .
"\x00" .
"\x1A" .
"\x15" .
"\x15" .
"\x15" .
"\x15" .
"\x00" .

# n
"\x00" .
"\x00" .
"\x16" .
"\x19" .
"\x11" .
"\x11" .
"\x11" .
"\x00" .

# o
"\x00" .
"\x00" .
"\x0E" .
"\x11" .
"\x11" .
"\x11" .
"\x0E" .
"\x00" .

# p
"\x00" .
"\x00" .
"\x16" .
"\x19" .
"\x19" .
"\x16" .
"\x10" .
"\x10" .

# q
"\x00" .
"\x00" .
"\x0D" .
"\x13" .
"\x13" .
"\x0D" .
"\x01" .
"\x01" .

# r
"\x00" .
"\x00" .
"\x16" .
"\x19" .
"\x10" .
"\x10" .
"\x10" .
"\x00" .

# s
"\x00" .
"\x00" .
"\x0F" .
"\x10" .
"\x0E" .
"\x01" .
"\x1E" .
"\x00" .

# t
"\x08" .
"\x08" .
"\x1E" .
"\x08" .
"\x08" .
"\x08" .
"\x06" .
"\x00" .

# u
"\x00" .
"\x00" .
"\x12" .
"\x12" .
"\x12" .
"\x12" .
"\x0D" .
"\x00" .

# v
"\x00" .
"\x00" .
"\x11" .
"\x11" .
"\x11" .
"\x0A" .
"\x04" .
"\x00" .

# w
"\x00" .
"\x00" .
"\x11" .
"\x11" .
"\x15" .
"\x15" .
"\x0A" .
"\x00" .

# x
"\x00" .
"\x00" .
"\x11" .
"\x0A" .
"\x04" .
"\x0A" .
"\x11" .
"\x00" .

# y
"\x00" .
"\x00" .
"\x11" .
"\x11" .
"\x13" .
"\x0D" .
"\x01" .
"\x0E" .

# z
"\x00" .
"\x00" .
"\x1F" .
"\x02" .
"\x04" .
"\x08" .
"\x1F" .
"\x00" .

# {
"\x02" .
"\x04" .
"\x04" .
"\x08" .
"\x04" .
"\x04" .
"\x02" .
"\x00" .

# |
"\x04" .
"\x04" .
"\x04" .
"\x00" .
"\x04" .
"\x04" .
"\x04" .
"\x00" .

# }
"\x08" .
"\x04" .
"\x04" .
"\x02" .
"\x04" .
"\x04" .
"\x08" .
"\x00" .

# ~
"\x00" .
"\x08" .
"\x15" .
"\x02" .
"\x00" .
"\x00" .
"\x00" .
"\x00";


#    (solid block) chr(219) = "\xDB" = "\333"
$bitmap_ch219 =
"\x1F" .
"\x1F" .
"\x1F" .
"\x1F" .
"\x1F" .
"\x1F" .
"\x1F" .
"\x1F";

#    (<sup>2</sup>) in DOS/IBM-PC codes this is chr(253) = "\xFD" = "\375", but in ANSI this is chr(178) = "\xB2" = "\262"
$bitmap_ch253 =
"\x0E" .
"\x12" .
"\x04" .
"\x1F" .
"\x00" .
"\x00" .
"\x00" .
"\x00";


# print "bitmap is " . length($bitmap_chars_5x8) . " bytes long\n";


sub get_bitmap_for_char {
   local( $ch ) = @_;
   local( $ccode ) = ord($ch);
   local( $result );
   if (($ccode < 0x20) || ($ccode > 0x7E)) {
      if (219 == $ccode) {
         $result = $bitmap_ch219;  # solid block
      } elsif ((253 == $ccode) || (178 == $ccode)) {
         $result = $bitmap_ch253;  # superscript 2
      } else {
         $result = substr( $bitmap_chars_5x8, 0, 8 );  # blank
      }
   } else {
      $ccode -= 0x20;
      $result = substr( $bitmap_chars_5x8, 8 * $ccode, 8 );
   }
   return $result;
}


# sub show_char {
#    local( $ch ) = @_;
#    local( $i, $j, $row );
#    $bits = &get_bitmap_for_char( $ch );
#    for ($i=0; $i < length($bits); $i++) {
#       $row = ord(substr($bits,$i,1));
#       for ($j=0; $j<8; $j++) {
#          if ($row & 0x80) {
#             print "*";
#          } else {
#             print " ";
#          }
#          $row <<= 1;
#       }
#       print "\n";
#    }
# }
# sub show_str {
#    local( $chrs ) = @_;
#    local( $i, $ch );
#    print "'$chrs'\n";
#    for ($i=0; $i<length($chrs); $i++) {
#       $ch = substr($chrs,$i,1);
#       print "$i: ($ch)\n";
#       &show_char( $ch );
#    }
# }
# &show_str( 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789,.;:\'"!@#$%^&*()-_=+\[]{|}~`' );


1;
