#!/usr/bin/perl

# Function to generate a call-traceback diagnostic, for debugging.
# (Compatible with both Perl4 and Perl5.)
#
# This file is UNCOPYRIGHTED, by David A. Burton, 2001-2010
# Cary, NC  USA
# +1-919-481-0149
# Email: http://www.burtonsys.com/email/
#
# You can use a "require" to pull this into another Perl program, like this:
#
#   @INC = ('.','..');
#   require "traceback.pl";


# display a call-traceback diagnostic, for debugging
sub traceback {
    package DB; # necessary only in Perl 5 -- give access to DB'args
    print STDERR "***** Traceback (most recent call first):\n";
    local($package,$filename,$line,$subname,$hasargs,$wantarray,$pkg1,$sub1,$arglist,$i,$arg);
    local(@args1);
    local($lvl) = 0;
    while (1) {
       ($package, $filename, $line, $subname, $hasargs, $wantarray) = caller($lvl);
       if ($hasargs) {
          @args1 = @DB'args;  # magically set by call to caller($lvl)
       }
       if ((!defined $filename) || ('' eq $filename)) {
          last;
       }
       if ('main' ne $package) {
          print STDERR "pkg='$package' ";
       }
       if ($subname =~ /\'|\:\:/) {
          ($pkg1,$sub1) = split( /\'|\:\:/, $subname );
          if (('main' eq $pkg1) && ('main' eq $package)) {
             $subname = $sub1;
          }
       }
       $arglist = '';
       print STDERR "sub $subname";
       if ($hasargs) {
          $arglist = '';
          for ($i=0; $i<=$#args1; $i++) {
             $arg = $args1[$i];
             if (!defined $arg) {
                $arg = '{undef}';
             } elsif ($arg !~ /^(\-|)[0-9]+(\.[0-9]+)$/) {
                $arg =~ s/\'/\\\'/g;
                $arg =~ s/\r/\\r/g;
                $arg =~ s/\n/\\n/g;
                $arg =~ s/\t/\\t/g;
                if ($arg =~ /[\'\"]/) {
                   $arg = '\'' . $arg . '\'';
                }
             }
             if ((length($arg)+length($arglist)) > 40) {
                $arglist .= ', ...';
                last;
             } else {
                $arglist .= ', ' . $arg;
             }
          }
          if (length($arglist) < 3) {
             $arglist = '(?)';  # I don't think this will really happen
          } else {
             $arglist = substr( $arglist, 2 );
             $arglist = '(' . $arglist . ')';
          }
       }
       print STDERR "$arglist called";
       if ($wantarray) {
          print STDERR " in array context";
       }
       print STDERR " from $filename, line $line\n";
       $lvl++;
    }
    print STDERR "***** traceback done.\n";
} # traceback


sub traceback2 {
   &traceback;
   exit 1;
}


# return true value to 'require'
1;
